unit GistogramMain;
(*
   ========================================================================
    Gistogram  (  )
         .
   : BitMap.PixelFormat = pf24bit
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)
interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, jpeg, ExtCtrls, Math,
  ToolWin, ImgList, Buttons,
  //    Image Tools
  MainData,
  //   
  EngineMainData01, EngineImgService01, GraphXYv3,
  //   
  GistogramMainData01,
  GistogramService01, GistogramService02, GistogramService03,
  VisualPointEditor01;

type
  TFormGistogram = class(TForm)
    ProgressBar1: TProgressBar;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    PanelConv: TPanel;
    ImageConv: TImage;
    ImageLSrc: TImage;
    ImageLTrg: TImage;
    MemoRep: TMemo;
    Label2: TLabel;
    PanelRed: TPanel;
    ImageGistR: TImage;
    ImageGRed: TImage;
    Label5: TLabel;
    PanelGreen: TPanel;
    ImageGistG: TImage;
    ImageGGreen: TImage;
    Label6: TLabel;
    PanelBlue: TPanel;
    ImageGistB: TImage;
    ImageGBlue: TImage;
    Label7: TLabel;
    PanelLight: TPanel;
    ImageGistLight: TImage;
    ImageGLight: TImage;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    ImageList1: TImageList;
    Panel1: TPanel;
    ToolBar1: TToolBar;
    TB1New: TToolButton;
    TB1Sep2: TToolButton;
    TB1Load: TToolButton;
    TB1Sep3: TToolButton;
    TB1Save: TToolButton;
    TB1Sep4: TToolButton;
    TB1Neg: TToolButton;
    TB1Sep1: TToolButton;
    TB1LoadFromFile: TToolButton;
    TB1SaveToFile: TToolButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    PageControlFunc: TPageControl;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    Label23: TLabel;
    cbBoxFuncFormula: TComboBox;
    Label17: TLabel;
    EdXB: TEdit;
    Label21: TLabel;
    EdXE: TEdit;
    UpDownX: TUpDown;
    Label22: TLabel;
    cbBoxMaxXNumb: TComboBox;
    Label24: TLabel;
    TB1Run: TToolButton;
    ToolButton2: TToolButton;
    Label18: TLabel;
    cbBoxFuncType: TComboBox;
    Label25: TLabel;
    Label27: TLabel;
    EdLGrate: TEdit;
    UpDnLGrate: TUpDown;
    Label28: TLabel;
    cbBoxSectionNumb: TComboBox;
    SpButGistSrc: TSpeedButton;
    Label19: TLabel;
    SpButGistTrg: TSpeedButton;
    Label20: TLabel;
    TabSheet7: TTabSheet;
    PanelAcImg: TPanel;
    PanelMDS: TPanel;
    StTextMS: TStaticText;
    StTextMD: TStaticText;
    StTextMM: TStaticText;
    StTextNumWhitePr: TStaticText;
    StTextNumWhite: TStaticText;
    StTextNumBlackPr: TStaticText;
    StTextNumBlack: TStaticText;
    stTextNumAll: TStaticText;
    stTextNumSP: TStaticText;
    stTextLLevel: TStaticText;
    stTextLLmp: TStaticText;
    stTextNameChannel: TStaticText;
    SpButtCnL: TSpeedButton;
    SpButtCnB: TSpeedButton;
    SpButtCnG: TSpeedButton;
    SpButtCnR: TSpeedButton;
    Label31: TLabel;
    Label30: TLabel;
    Label29: TLabel;
    Label26: TLabel;
    Label13: TLabel;
    Label11: TLabel;
    Label8: TLabel;
    Label4: TLabel;
    Label12: TLabel;
    Label10: TLabel;
    Label1: TLabel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel1: TBevel;
    Bevel4: TBevel;
    Label3: TLabel;
    Label9: TLabel;
    Label32: TLabel;
    PanelSrcFun1: TPanel;
    PanelAcFunc: TPanel;
    ImgAcFrg: TImage;
    Panel2: TPanel;
    StTextChoiceLamp: TStaticText;
    StTextChoiceStat: TStaticText;
    Label33: TLabel;
    Label34: TLabel;
    StTextSelRow: TStaticText;
    StTextSelCol: TStaticText;
    Label37: TLabel;
    Label38: TLabel;
    Label35: TLabel;
    SpButtChoiceR: TSpeedButton;
    SpButtChoiceG: TSpeedButton;
    SpButtChoiceB: TSpeedButton;
    SpButtChoiceL: TSpeedButton;
    Bevel6: TBevel;
    Bevel5: TBevel;
    SpButtAcRow: TSpeedButton;
    SpButtAcCol: TSpeedButton;
    Label36: TLabel;
    Bevel7: TBevel;
    Label41: TLabel;
    Label39: TLabel;
    StTextME: TStaticText;
    Label40: TLabel;
    StTextDE: TStaticText;
    SpButtRunAcMD: TSpeedButton;
    SpButtRunAcCnvl: TSpeedButton;
    StTextFun1: TStaticText;
    StTextFun2: TStaticText;
    CmbBoxAcCnvl: TComboBox;
    Label42: TLabel;
    GroupBox1: TGroupBox;
    Label44: TLabel;
    StTextAcIW: TStaticText;
    Label45: TLabel;
    StTextAcIH: TStaticText;
    Label43: TLabel;
    StTextAcINumPnt: TStaticText;
    PageControl2: TPageControl;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    PanelFun3: TPanel;
    StTextFun3: TStaticText;
    CmbBoxFun3: TComboBox;
    GroupBox2: TGroupBox;
    Label46: TLabel;
    StTextFragME: TStaticText;
    Label47: TLabel;
    StTextFragDE: TStaticText;
    StTextFragChanel: TStaticText;
    Label48: TLabel;
    LbIdChanel: TLabel;
    GroupBox3: TGroupBox;
    StTextFragDivSrc: TStaticText;
    Label49: TLabel;
    Label50: TLabel;
    StTextLightLevel: TStaticText;
    procedure FormCreate(Sender: TObject);
    procedure ImageGistLightMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure TB1NewClick(Sender: TObject);
    procedure TB1LoadClick(Sender: TObject);
    procedure TB1SaveClick(Sender: TObject);
    procedure TB1NegClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure cbBoxMaxXNumbClick(Sender: TObject);
    procedure TB1SaveToFileClick(Sender: TObject);
    procedure TB1LoadFromFileClick(Sender: TObject);
    procedure cbBoxFuncFormulaClick(Sender: TObject);
    procedure TB1RunClick(Sender: TObject);
    procedure cbBoxFuncTypeClick(Sender: TObject);
    procedure cbBoxSectionNumbClick(Sender: TObject);
    procedure UpDnLGrateClick(Sender: TObject; Button: TUDBtnType);
    procedure UpDownXClick(Sender: TObject; Button: TUDBtnType);
    procedure SpButGistSrcClick(Sender: TObject);
    procedure SpButGistTrgClick(Sender: TObject);
    procedure ImageGistRMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ImageGistGMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ImageGistBMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SpButtCnMDSClick(Sender: TObject);
    procedure SpButtRunAcMDClick(Sender: TObject);
    // ---------------------------------------------
    //    Row  Col 
    procedure SpButtAcRowColClick(Sender: TObject);
    //       
    procedure SpButtChoiceChannelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpButtRunAcCnvlClick(Sender: TObject);
    procedure CmbBoxFun3Click(Sender: TObject);


  private
    // ---------------------------------------------
    //  
    // ---------------------------------------------
    //   
    procedure InitGistogram();
    //     
    procedure ReportGistogram(ptGistRec : ptGistogramRec);
    //  . , , . 
    procedure ReportMDS(ptGistRec : ptGistogramRec);
    //     
    procedure NormalizeGistorgamPanels();
    // ---------------------------------------------
    //   
    // ---------------------------------------------
    //    
    procedure InitTFunction();
    //   "    "
    procedure PEditorEvnt(Sender : TObject; pdCode : TpdCode);
    //  UpDown 
    procedure InitAllUpDown();
    //       MemoReport
    procedure ShowFuncReport (RqRep : TMemo; RqTitul : string);
    //      
    procedure FuncToPointEditor(RqFuncCode : byte);
    //        
    procedure SpecFuncToPointEditor();
    // ---------------------------------------------
    //  
    // ---------------------------------------------
    //    
    procedure InitACorrelation();
    //      
    procedure ShowRulMove(Sender : TObject; Row, Col : integer);
    //     
    procedure RulChoice (Sender : TObject; Row, Col : integer);
    //      
    procedure RulBegin (Sender : TObject);
    //       
    procedure MouseMoveFun1(Sender: TObject;
                            Shift: TShiftState; X, Y: Integer);
    //        
    procedure MouseMoveFun2(Sender: TObject;
                            Shift: TShiftState; X, Y: Integer);
    //        
    procedure MouseMoveFun3(Sender: TObject;
                            Shift: TShiftState; X, Y: Integer);
    //    
    procedure ShortClearAcor();
    //    
    procedure FullClearAcor();
    //      
    procedure PrepareAnShowFun3();
    // ---------------------------------------------
    //   
    // ---------------------------------------------
    //     ,
    //      
    procedure ClearFragImgStat();
    //      ,
    //      
    procedure FragImgStat();
    // ---------------------------------------------
  public
    // ---------------------------------------------
    //  
    // ---------------------------------------------
    //   
    procedure ShowEmtyGistogram();
    //       
    procedure CalcAndShowGistAndMDS(ptImgTab : ptImgTabBGR);
    //      
    procedure ShowSelectGistogram();
    // ---------------------------------------------
    //   
    // ---------------------------------------------
    //  
    // ---------------------------------------------
  end;

//    
var FormGistogram : TFormGistogram;

// ========================================================================
// ========================================================================
implementation
{$R *.dfm}
// ========================================================================
// ========================================================================
//
//     
//
// ========================================================================
// ------------------------------------------------------------------------
// 06.04.2014
//   
procedure TFormGistogram.InitGistogram();
begin
    //     
    NormalizeGistorgamPanels();
end;
// ------------------------------------------------------------------------
// 06.04.2014
//    
procedure TFormGistogram.InitTFunction();
begin
    //    
    FuncPanelPlane (PanelConv, ImageLTrg, ImageConv, ImageLSrc, 'L');
    //    
    PointEditor := TPointEditor.Greate(ImageConv);
    //    "    "
    PointEditor.onPointEvent := PEditorEvnt;
    // 
    ShowFuncReport(MemoRep, '  ');
    //       
    TestFuncDirectory();
    //  UpDown 
    InitAllUpDown();
    //      
    cbBoxMaxXNumb.OnClick := nil;
    MaxFuncNumb := 16;
    cbBoxMaxXNumb.ItemIndex := 2;
    cbBoxMaxXNumb.OnClick := cbBoxMaxXNumbClick;
end;
// ------------------------------------------------------------------------
// 06.04.2014
//   
procedure TFormGistogram.InitACorrelation();
begin
    //    Image  
    WorkImgAcFrg := ImgAcFrg;
    // -----------------------------------
    //     
    WHSelector := TWHSelector.Create(ImgAcFrg);
    //  
    //      
    WHSelector.onRulMove := ShowRulMove;
    //    
    WHSelector.onChoice := RulChoice;
    //     
    WHSelector.onRulBegin := RulBegin;
    StTextChoiceStat.Caption := '  ';
    StTextChoiceLamp.Color   := clYellow;
    //    
    AcExtract.IdRowCol := 'R';  //   
    //     
    AcExtract.IdChanel := 'L';  //  Light
    // -----------------------------------
    //    1   
    GraphXY1 := TGraphXY.Create(PanelSrcFun1);
    GraphXY1.GraphTitul := '  .  ';
    GraphXY1.PicAxesX := '%3.0f';   //      
    //      
    GraphXY1.OnMouseMove := MouseMoveFun1;
    // -----------------------------------
    //    2   
    GraphXY2 := TGraphXY.Create(PanelAcFunc);
    GraphXY2.GraphTitul := '    ';
    GraphXY2.PicAxesX := '%3.0f';   //      
    //      
    GraphXY2.OnMouseMove := MouseMoveFun2;
    // -----------------------------------
    //    3   
    GraphXY3 := TGraphXY.Create(PanelFun3);
    GraphXY3.GraphTitul := '  ';
    GraphXY3.PicAxesX := '%3.0f';   //      
    //      
    GraphXY3.OnMouseMove := MouseMoveFun3;
end;
// ------------------------------------------------------------------------
// 17.02.2013
//  
procedure TFormGistogram.FormCreate(Sender: TObject);
begin
  // -------------------------------------------
  //   ()
  InitGistogram();
  // -------------------------------------------
  //     ()
  InitTFunction();
  // -------------------------------------------
  //    ()
  InitACorrelation();
end;
// ------------------------------------------------------------------------
// 17.02.2013
//    (  )
procedure TFormGistogram.FormDestroy(Sender: TObject);
begin
  // -------------------------------------------
  //  
  // -------------------------------------------
  //   
  if Assigned(PointEditor)
  then begin
     PointEditor.Free;
     PointEditor := nil;
  end;
  // -------------------------------------------
  //  
  // -------------------------------------------
  if Assigned(WHSelector)
  then begin
     WHSelector.Free;
     WHSelector := nil;
  end;
  if Assigned(GraphXY1)
  then begin
     GraphXY1.Free;
     GraphXY1 := nil;
  end;
  if Assigned(GraphXY2)
  then begin
     GraphXY2.Free;
     GraphXY2 := nil;
  end;
  if Assigned(GraphXY3)
  then begin
     GraphXY3.Free;
     GraphXY3 := nil;
  end;
end;
// ------------------------------------------------------------------------
//    
// ------------------------------------------------------------------------
// 06.04.2014
//     
//     
procedure TFormGistogram.FormShow(Sender: TObject);
begin
   // ShowMessage('  ');
   ShowEmtyGistogram();           //   
   // :
   // 0 -  
   // 1 -       
   // 2 -   ,  , 
   case GistogramCMD of
   1 :  begin
          //    
          SpButGistSrc.Down := True;
          //     
          ShowSelectGistogram();
          //  
          PageControl1.TabIndex := 0;
        end;
   2 :  begin
          //    
          SpButGistSrc.Down := True;
          //     
          ShowSelectGistogram();
          //  
          PageControl1.TabIndex := 2;
        end;
   else begin
          PageControl1.TabIndex := 0;  //  
        end;
   end;
   //   ComboBox
   CmbBoxAcCnvl.ItemIndex := 0;
   CmbBoxFun3.ItemIndex := 0;
   //       
   if Length(TabColorFrag) > 0
   then begin
     StTextAcIW.Caption := IntToStr(Length(TabColorFrag[0]));
     StTextAcIH.Caption := IntToStr(Length(TabColorFrag) - 1);
     StTextAcINumPnt.Caption := IntToStr(
                                         Length(TabColorFrag)
                                       * Length(TabColorFrag[0])
                                        );
   end else begin
     StTextAcIW.Caption := '0';
     StTextAcIH.Caption := '0';
     StTextAcINumPnt.Caption := '0';
     //     , 
     ClearFragImgStat();
   end;
end;
// ------------------------------------------------------------------------
// 06.04.2014
//     
//    
procedure TFormGistogram.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  // ShowMessage('   ');
  //    
  FullClearAcor();
end;
// ========================================================================
//
//      (   3.5)
//      GistogramService01
//
// ========================================================================
//     ,
//     
procedure TFormGistogram.ClearFragImgStat();
begin
   //  
  StTextFragME.Caption := '0';
  StTextFragDE.Caption := '0';
  StTextFragChanel.Color := clBtnFace;
  StTextFragDivSrc.Caption := ' ------- ';
  StTextLightLevel.Caption := ' ------- ';
end;

//      ,
//      
procedure TFormGistogram.FragImgStat();
var RqCanel  : char;
    MECanel  : extended;
    DECanel  : extended;
    WE1, WE2, WE3 : extended;
    LightLevel : extended;
begin
  //  
  ClearFragImgStat();
  //  
  if (Length(SrcImgTabBGR) > 0) and (Length(TabColorFrag) > 0)
  then begin
     // --------------------------
     //    Light
     RqCanel := 'L';
     StTextFragChanel.Color := RGB(255,255,255);
     //      
     MECanel := CalcFragME(RqCanel);
     //     
     DECanel := CalcFragDE(RqCanel, MECanel);
     //  
     StTextFragME.Caption := FloatToStr(MECanel);
     StTextFragDE.Caption := FloatToStr(DECanel);
     // --------------------------
     //   
     if (GistRecW.IdImg = 'M')   //  
     then begin
        WE1 := GistRecW.NumAllPnt;
        if WE1 > 0
        then begin
           //    
           WE2 := Length(TabColorFrag)* Length(TabColorFrag[0]);
           //       
           WE3 := WE2 / WE1;
           StTextFragDivSrc.Caption := FloatToStr(WE3 * 100) + ' %';
           //      
           LightLevel := ( GistRecW.MDSRec.ML / 100 ) * MECanel * WE3;
           StTextLightLevel.Caption := FloatToStr(LightLevel) + ' %';
        end;
     end;
  end;
end;

// ========================================================================
//
//        
//      GistogramService01
//        3.5
//
// ========================================================================
// ------------------------------------------------------------------------
// 17.02.2013
//     
procedure TFormGistogram.NormalizeGistorgamPanels();
begin
  GistPanelPlane(PanelRed, ImageGistR, ImageGRed, 'R');
  GistPanelPlane(PanelGreen, ImageGistG, ImageGGreen, 'G');
  GistPanelPlane(PanelBlue, ImageGistB, ImageGBlue, 'B');
  GistPanelPlane(PanelLight, ImageGistLight, ImageGLight, 'L');
end;
// ------------------------------------------------------------------------
// 04.04.2014
//    ( )
procedure TFormGistogram.ShowEmtyGistogram();
begin
  //  Image  
  ClearImage (ImageGistR, PanelRed.Color);
  ClearImage (ImageGistG, PanelGreen.Color);
  ClearImage (ImageGistB, PanelBlue.Color);
  ClearImage (ImageGistLight, PanelLight.Color);
end;
// ------------------------------------------------------------------------
// 24.10.2008.
//     
procedure TFormGistogram.ReportGistogram(ptGistRec : ptGistogramRec);
begin
    // 
   with ptGistRec^ do
   begin
      //    
      stTextNumAll.Caption := IntToStr(NumAllPnt);
      if NumAllPnt > 0
      then begin
         //     
         NumBlackPnt := ptGistRecW^.ChnSrc.ChnL[0];
         StTextNumBlack.Caption := IntToStr(NumBlackPnt);
         StTextNumBlackPr.Caption := Format('%8.5f',
                                            [100 * NumBlackPnt / NumAllPnt])
                                    + ' %';
         //     
         NumWhitePnt := ptGistRecW^.ChnSrc.ChnL[255];
         StTextNumWhite.Caption := IntToStr(NumWhitePnt);
         StTextNumWhitePr.Caption := Format('%8.5f',
                                            [100 * NumWhitePnt / NumAllPnt])
                                   + ' %';
       end
       else begin
         StTextNumBlack.Caption := '0';
         StTextNumBlackPr.Caption := '0 %';
         StTextNumWhite.Caption := '0';
         StTextNumWhitePr.Caption := '0 %';
       end;
       //   
       ShowGistogram(ImageGistR, ptGistRecW^.ChnNrm.ChnR);
       ShowGistogram(ImageGistG, ptGistRecW^.ChnNrm.ChnG);
       ShowGistogram(ImageGistB, ptGistRecW^.ChnNrm.ChnB);
       ShowGistogram(ImageGistLight, ptGistRecW^.ChnNrm.ChnL);
   end;
end;
// ------------------------------------------------------------------------
// 04.04.2014
//  . , , . 
procedure TFormGistogram.ReportMDS(ptGistRec   : ptGistogramRec);
var M, D, S : extended;
begin
   M := 0; D := 0; S := 0;
   //  
   if not (ptGistRec = nil)
   then begin
      with ptGistRec^.MDSRec do
      begin
         if SpButtCnR.Down
         then begin M := MR; D := DR; S := SR; end;
         if SpButtCnG.Down
         then begin M := MG; D := DG; S := SG; end;
         if SpButtCnB.Down
         then begin M := MB; D := DB; S := SB; end;
         if SpButtCnL.Down
         then begin M := ML; D := DL; S := SL; end;
      end;
   end;
   StTextMM.Caption := Format('%g', [M]);
   StTextMD.Caption := Format('%g', [D]);
   StTextMS.Caption := Format('%g', [S]);
end;
// ------------------------------------------------------------------------
// 04.04.2014
//    
//        
procedure TFormGistogram.CalcAndShowGistAndMDS(ptImgTab : ptImgTabBGR);
begin
    //     
    //     
    ptGistRecW := Addr(GistRecW);
    //       
    RunAllCalculateAGistogram(ptImgTab, ProgressBar1, ptGistRecW);
    //     
    ReportGistogram(ptGistRecW);
    //  . , , . 
    ReportMDS(ptGistRecW);
end;
// ------------------------------------------------------------------------
//      
// ------------------------------------------------------------------------
// 04.04.2014
//      
procedure TFormGistogram.ImageGistRMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if (X >=0) and (X <= 255) and (ptGistRecW <> nil)
  then begin
     stTextLLmp.Color := RGB(X,0,0);                //  
     stTextLLevel.Caption := IntToStr(X);           //  
     //  R-
     with ptGistRecW^.ChnSrc
     do stTextNumSP.Caption := IntToStr(ChnR[X]);
  end;
  stTextNameChannel.Caption := ' RED ()';
end;
// ------------------------------------------------------------------------
// 04.04.2014
//      
procedure TFormGistogram.ImageGistGMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if (X >=0) and (X <= 255) and (ptGistRecW <> nil)
  then begin
     stTextLLmp.Color := RGB(0,X,0);                 //  
     stTextLLevel.Caption := IntToStr(X);            //  
      //  G-
     with ptGistRecW^.ChnSrc
     do stTextNumSP.Caption := IntToStr(ChnG[X]);
  end;
  stTextNameChannel.Caption := ' RED ()';
end;
// ------------------------------------------------------------------------
// 04.04.2014
//      
procedure TFormGistogram.ImageGistBMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if (X >=0) and (X <= 255) and (ptGistRecW <> nil)
  then begin
     stTextLLmp.Color := RGB(0,0,X);                 //  
     stTextLLevel.Caption := IntToStr(X);            //  
     //  B-
     with ptGistRecW^.ChnSrc
     do stTextNumSP.Caption := IntToStr(ChnB[X]);
  end;
  stTextNameChannel.Caption := ' BLUE ()';
end;
// ------------------------------------------------------------------------
// 04.04.2014
//         
procedure TFormGistogram.ImageGistLightMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if (X >=0) and (X <= 255) and (ptGistRecW <> nil)
  then begin
     stTextLLmp.Color := RGB(X,X,X);                 //  
     stTextLLevel.Caption := IntToStr(X);            //  
     //  L-
     with ptGistRecW^.ChnSrc
     do stTextNumSP.Caption := IntToStr(ChnL[X]);
  end;
  stTextNameChannel.Caption := ' LIGHT ()';
end;
// ------------------------------------------------------------------------
// 04.04.2014
//        R,G,B,L - 
procedure TFormGistogram.SpButtCnMDSClick(Sender: TObject);
begin
  //    
  ReportMDS(ptGistRecW);
end;
// ------------------------------------------------------------------------
// 04.04.2014
// ,      
procedure TFormGistogram.ShowSelectGistogram();
begin
   Screen.Cursor := crHourGlass;
   Self.Refresh;
   // ---------------------------------------------------
   //   
   stTextNameChannel.Caption := '';       //  
   stTextLLmp.Color := PanelMDS.Color;    //  
   stTextLLevel.Caption := '';            //  
   stTextNumSP.Caption  := '';            //  
   // ---------------------------------------------------
   //       
   if SpButGistSrc.Down  //    
   then begin
     CalcAndShowGistAndMDS(Addr(SrcImgTabBGR));
     Self.Caption :='    :  ';
     GistRecW.IdImg := 'M';   // 'M' -  
   end;
   if SpButGistTrg.Down  //    
   then begin
     CalcAndShowGistAndMDS(Addr(TrgImgTabBGR));
     Self.Caption :='    :  ';
     GistRecW.IdImg := 'F';   // 'F' -  
   end;
   // ---------------------------------------------------
   //      ,
   //      
   FragImgStat();
   // ---------------------------------------------------
   Screen.Cursor := crDefault;
end;
// ------------------------------------------------------------------------
// 04.04.2014
//     
procedure TFormGistogram.SpButGistSrcClick(Sender: TObject);
begin
  // ,      
  ShowSelectGistogram();
end;
// ------------------------------------------------------------------------
// 04.04.2014
//     
procedure TFormGistogram.SpButGistTrgClick(Sender: TObject);
begin
  // ,      
  ShowSelectGistogram();
end;
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// ========================================================================
//
//    
//      GistogramService03
//
// ========================================================================
// 13.04.2014
//    
procedure TFormGistogram.ShortClearAcor();
begin
   //      
   StTextME.Caption := '';
   StTextDE.Caption := '';
   //  
   if Assigned(GraphXY1) then GraphXY1.FullEraseAreaXY;
   if Assigned(GraphXY2) then GraphXY2.FullEraseAreaXY;
   StTextFun1.Caption := '';
   StTextFun2.Caption := '';
end;
// ------------------------------------------------------------------------
// 13.04.2014
//    
procedure TFormGistogram.FullClearAcor();
begin
   // -----------------
   //     
   WHSelector.HideRulers;   //  
   WHSelector.ClearImage;   //   
   WHSelector.ShowRulers;   //  
   //    
   SetLength(TabColorFrag, 0);
   // -----------------
   //    
   ShortClearAcor();
   // -----------------
   StTextChoiceStat.Caption := '  ';
   StTextChoiceLamp.Color   := clYellow;
   with AcExtract
   do begin
      //   - .    
      MDOk := FALSE;
      //   
      ChoiceRow := -1;
      ChoiceCol := -1;
      //   
      SetLength(SrcPntArr, 0);
      SetLength(SrcPntArrCM, 0);
      SetLength(FuncArr, 0);
      SetLength(CnvlArr, 0);
      SetLength(Graph1Arr, 0);
      SetLength(Graph2Arr, 0);
      SetLength(Graph3Arr, 0);
   end;
   //     
   if Assigned(GraphXY3) then GraphXY3.FullEraseAreaXY;
   StTextFun3.Caption := '';
end;
// ------------------------------------------------------------------------
// 05.04.2014
//      
procedure TFormGistogram.ShowRulMove (Sender : TObject; Row, Col : integer);
begin
   StTextSelRow.Caption := IntToStr(Row);
   StTextSelCol.Caption := IntToStr(Col);
end;
// ------------------------------------------------------------------------
// 06.04.2014
//    
procedure TFormGistogram.RulChoice (Sender : TObject; Row, Col : integer);
begin
   StTextChoiceStat.Caption := ' ';
   StTextChoiceLamp.Color   := clLime;
   StTextSelRow.Caption := IntToStr(Row);
   StTextSelCol.Caption := IntToStr(Col);
   AcExtract.ChoiceRow := Row;
   AcExtract.ChoiceCol := Col;
end;
// ------------------------------------------------------------------------
// 06.04.2014
//     
procedure TFormGistogram.RulBegin (Sender : TObject);
begin
  StTextChoiceStat.Caption := '  ';
  StTextChoiceLamp.Color   := clYellow;
  //    
  ShortClearAcor();
end;
// ------------------------------------------------------------------------
// 13.04.2014
//       
procedure TFormGistogram.SpButtChoiceChannelClick(Sender: TObject);
begin
   with AcExtract
   do begin
        IdChanel := 'L';   //   
        case (Sender as TSpeedButton).Tag of
        1 : IdChanel := 'R';
        2 : IdChanel := 'G';
        3 : IdChanel := 'B';
        4 : IdChanel := 'L';
        end;
   end;
   //    
   ShortClearAcor();
end;
// ------------------------------------------------------------------------
// 13.04.2014
//    Row  Col 
procedure TFormGistogram.SpButtAcRowColClick(Sender: TObject);
begin
   with AcExtract
   do begin
        IdRowCol := 'R';   //   
        case (Sender as TSpeedButton).Tag of
        1 : IdRowCol := 'R';
        2 : IdRowCol := 'C';
        end;
   end;
   //    
   ShortClearAcor();
end;

// ------------------------------------------------------------------------
// 12.04.2014
//       
procedure TFormGistogram.MouseMoveFun1(Sender: TObject;
                                       Shift: TShiftState; X, Y: Integer);
var Ind : integer;
begin
   if not Assigned (AcExtract.Graph1Arr) then Exit;
   Ind := GraphXY1.XPixToArrInd(X, AcExtract.Graph1Arr);
   if (Ind >= 0)
   then begin
     StTextFun1.Caption := ' Func ( '
                         + Format('%3.0f', [AcExtract.Graph1Arr[Ind].X])
                         + ' ) = '
                         + Format('%8.4f', [AcExtract.Graph1Arr[Ind].Y]);
   end;
end;
// ------------------------------------------------------------------------
// 12.04.2014
//        
procedure TFormGistogram.MouseMoveFun2(Sender: TObject;
                                       Shift: TShiftState; X, Y: Integer);
var Ind : integer;
begin
   if not Assigned (AcExtract.Graph2Arr) then Exit;
   Ind := GraphXY2.XPixToArrInd(X, AcExtract.Graph2Arr);
   if (Ind >= 0) 
   then begin
     StTextFun2.Caption := ' Func ( '
                         + Format('%3.0f', [AcExtract.Graph2Arr[Ind].X])
                         + ' ) = '
                         + Format('%8.4f', [AcExtract.Graph2Arr[Ind].Y]);
   end;
end;

// ------------------------------------------------------------------------
// 12.04.2014
//        
procedure TFormGistogram.MouseMoveFun3(Sender: TObject;
                                       Shift: TShiftState; X, Y: Integer);
var Ind : integer;
begin
   if not Assigned (AcExtract.Graph3Arr) then Exit;
   Ind := GraphXY3.XPixToArrInd(X, AcExtract.Graph3Arr);
   if (Ind >= 0)
   then begin
     StTextFun3.Caption := ' Func ( '
                         + Format('%3.0f', [AcExtract.Graph3Arr[Ind].X])
                         + ' ) = '
                         + Format('%5.4f', [AcExtract.Graph3Arr[Ind].Y]);
   end;
end;
// ------------------------------------------------------------------------
// 12.04.2014
//      
procedure TFormGistogram.PrepareAnShowFun3();
var Ind  : integer;
    Rect : integer;
begin
   with AcExtract
   do begin
        if (High(FuncArr) > 0) and (Length(FuncArr) = Length(SrcPntArrCM))
        then begin
           Rect := High(FuncArr) div 5;
           for Ind := 0 to High(FuncArr)
           do begin
               case CmbBoxFun3.ItemIndex of
               1 : FuncArr[Ind] := Ind / High(FuncArr);
               2 : FuncArr[Ind] := 1 - Ind / High(FuncArr);
               3 : begin
                     if (Ind >= 2 * Rect) and
                        (Ind <= 3 * Rect)
                     then FuncArr[Ind] := 1
                     else FuncArr[Ind] := 0;
                   end;
               else FuncArr[Ind] := 1;
               end;
               Graph3Arr[Ind].X := Ind;
               Graph3Arr[Ind].Y := FuncArr[Ind];
           end;
           GraphXY3.FullEraseAreaXY;
           GraphXY3.ShowGraphXY(Graph3Arr, clLime);
        end
        else begin
           GraphXY3.FullEraseAreaXY;
        end;
   end; // of with
end;

// ------------------------------------------------------------------------
// 06.04.2014
//       . 
//     
procedure TFormGistogram.SpButtRunAcMDClick(Sender: TObject);
begin
   //   
   if not Assigned(TabColorFrag)
   then begin
       MessageDlg('   ',
                   mtWarning, [mbOk], 0);
       Exit;
   end;
   with AcExtract
   do begin
     //     
     if PrepareAcExtract(IdRowCol)
     then begin
        //     ,
        //     
        CalcAndShowMDExtract(IdChanel);
        StTextME.Caption := FloatToStr(ME);
        StTextDE.Caption := FloatToStr(DE);
        //      
        PrepareAnShowFun3();
     end
     else begin
        //    
        ShortClearAcor();
     end;
   end; // of with
end;

// ------------------------------------------------------------------------
// 12.04.2014
procedure TFormGistogram.CmbBoxFun3Click(Sender: TObject);
begin
   //      
   PrepareAnShowFun3();
end;

// ------------------------------------------------------------------------
// 12.04.2014
//       
procedure TFormGistogram.SpButtRunAcCnvlClick(Sender: TObject);
var  RqAcCnvl : Char;
     Ind : integer;
begin
    //    ( / )
    RqAcCnvl := 'A';
    case CmbBoxAcCnvl.ItemIndex of
    1 : RqAcCnvl := 'C';
    end;
    with AcExtract do
    begin
       if MDOk and (High(SrcPntArrCM) > 1)
       then begin
          // ---------------------------------------------------------------
          //    
          // ---------------------------------------------------------------
          Convolution (RqAcCnvl,
                       AcExtract.DE,
                       SrcPntArrCM, //    f1(x)
                       FuncArr,     //     
                       CnvlArr      //     
                       );
          // ---------------------------------------------------------------
          //      
          // ---------------------------------------------------------------
          // 
          SetLength(Graph2Arr, Length(CnvlArr));
          for Ind := Low(Graph2Arr) to High(Graph2Arr)
          do begin
             Graph2Arr[Ind].X := Ind - (Length(Graph2Arr) div 2);
             Graph2Arr[Ind].Y := CnvlArr[Ind];
          end;
          GraphXY2.FullEraseAreaXY;
          GraphXY2.ShowGraphXY(Graph2Arr, clLime);
          // ---------------------------------------------------------------
       end
       else begin
          MessageDlg('  .   ',
                      mtWarning, [mbOk], 0);
       end;
    end;
end;
// ------------------------------------------------------------------------
// 
// ------------------------------------------------------------------------


// ========================================================================
//
//       
//      GistogramService02
//
// ========================================================================
// 06.03.2013
//  UpDown 
procedure TFormGistogram.InitAllUpDown();
begin
    //   
    UpDownX.OnClick := nil;
    UpDnLGrate.OnClick := nil;
    //     
    with UpDownX
    do begin
      Min := 10;
      Max := Round(FuncXMax - FuncXMin) * 100;
      Position := Max div 2;
      Increment := 10;
      //      
      FuncXE  := FuncXMin + (FuncXMax - FuncXMin)* Position / Max;
      EdXE.Text := FloatToStr(FuncXE);
    end;
    //      
    with UpDnLGrate
    do begin
      Increment := 1;
      Min := 0;
      Max := 4;
      Position := 0;
      EdLGrate.Text := IntToStr(Position);
    end;
    //   
    UpDownX.OnClick := UpDownXClick;
    UpDnLGrate.OnClick := UpDnLGrateClick;
end;

// ------------------------------------------------------------------------
//     
// ------------------------------------------------------------------------
// 17.02.2013
//    
procedure ShowPointArray(RqArr : TPointArray; RqRep : TMemo);
var Ind : integer;
begin
  RqRep.Lines.Add('   : ' + IntToStr(Length(RqArr)));
  RqRep.Lines.Add('      :');
  if Length(RqArr) > 0
  then begin
     for Ind := 0 to High(RqArr)
     do RqRep.Lines.Add(' X = ' + IntToStr(RqArr[Ind].X)
                     + #09  // 
                     +  ' Y = ' + IntToStr(RqArr[Ind].Y));
  end;
end;
// ------------------------------------------------------------------------
// 17.02.2013
//       MemoReport
procedure TFormGistogram.ShowFuncReport(RqRep : TMemo; RqTitul : string);
begin
  //         
   PointArray := PointEditor.SavePointArray;
   //  
   RqRep.Clear;
   RqRep.Lines.Add(RqTitul);
   ShowPointArray(PointArray, RqRep);
end;

// ------------------------------------------------------------------------
//     
// ------------------------------------------------------------------------
// 17.02.2013
//   "    "
procedure TFormGistogram.PEditorEvnt(Sender : TObject; pdCode : TpdCode);
begin
   //         
   PointArray := PointEditor.SavePointArray;
   // 
   MemoRep.Clear;
   case pdCode of
   pdAdd : ShowFuncReport(MemoRep, '  ');
   pdDel : ShowFuncReport(MemoRep, '   ');
   pdMov : ShowFuncReport(MemoRep, '  ');
   end;
end;
// ------------------------------------------------------------------------
// 17.02.2013
//   
procedure TFormGistogram.TB1NewClick(Sender: TObject);
begin
  //  
   PointEditor.PointEditorNewDoc(False);
   //         
   PointArray := PointEditor.SavePointArray;
   // 
   ShowFuncReport(MemoRep, '  ');
end;
// ------------------------------------------------------------------------
// 17.02.2013
//         
procedure TFormGistogram.TB1LoadClick(Sender: TObject);
begin
   //  
   PointEditor.LoadPointArray(SavePArray);
   // 
   ShowFuncReport(MemoRep, '  ');
end;
// ------------------------------------------------------------------------
// 17.02.2013
//        
procedure TFormGistogram.TB1SaveClick(Sender: TObject);
begin
   //  
   SavePArray := PointEditor.SavePointArray;
   // 
   ShowFuncReport(MemoRep, '  ');
end;
// ------------------------------------------------------------------------
// 17.02.2013
//    <-> 
procedure TFormGistogram.TB1NegClick(Sender: TObject);
begin
   //  Y       
   PointEditor.InvertDocAndShow();
   //         
   PointArray := PointEditor.SavePointArray;
   // 
   ShowFuncReport(MemoRep, '   Y');
end;

// ------------------------------------------------------------------------
//     
// ------------------------------------------------------------------------
// 24.02.2013
//    - .
procedure PrepareFuncTab();
var Ind, XNext, YNext : integer;
begin
   SetLength(FuncTab,0);
   //        
   PointArray  := PointEditor.SavePointArray;
   //  
   if Length(PointArray) < 2 then Exit;
   //    FuncTab
   SetLength(FuncTab, Length(PointArray));
   //     
   for Ind := Low(FuncTab) to High(FuncTab) - 1 do
   begin
      with FuncTab[Ind] do
      begin
         //    
         //    
         X := PointArray[Ind].X;
         Y := PointArray[Ind].Y;
         XNext := PointArray[Ind + 1].X;
         YNext := PointArray[Ind + 1].Y;
         if Abs(XNext - X) > 0
         then begin
            //  . 
            //   
            fVert := False;
            K := (YNext - Y)/(XNext - X);
         end
         else begin
            //  .  
            //   Y- 
            // .
            fVert := True;
            K := YNext;
         end;
      end;
   end;
   //  .   
   //  X-.  
   //   K := 255
   Ind := High(FuncTab);
   with FuncTab[Ind] do
   begin
       X := PointArray[Ind].X;
       Y := PointArray[Ind].Y;
       fVert := True;
       K := 255;
   end;
end;
// ------------------------------------------------------------------------
// 24.02.2013
//  -   .
procedure RunFuncTabOnePoint(var RqBGR : TBGR);
begin
  with PixCCB
  do begin
    // ---------------------
    //      
    wB  := RqBGR.B;
    wG  := RqBGR.G;
    wR  := RqBGR.R;
    // ---------------------
    //    
    wXL := (wB*wB + wG*wG + wR*wR)/3;
    wXL := Sqrt(wXL);
    if wXL > 255 then wXL := 255;
    XL  := Trunc(wXL);
    // ---------------------
    //      -  
    Ind   := 0;
    Found := False;
    mK    := 0;
    repeat
       if (XL >= FuncTab[Ind].X) and (XL <= FuncTab[Ind + 1].X)
       then begin
          Found := True;
          //  
          XLB    := FuncTab[Ind].X;
          YLB    := FuncTab[Ind].Y;
          wKL    := FuncTab[Ind].K;
          //     
          if not FuncTab[Ind].fVert
          then YL := Trunc(YLB + wKL * (XL - XLB))
          else YL := Trunc(wKL);
          //   
          if XL > 0 then mK := (YL / XL) else mK := 0;
       end;
       Inc(Ind);
    until Found or (Ind >= High(FuncTab));
    // ---------------------
    if Found
    then begin
       //      
       wB := mK * wB;
       wG := mK * wG;
       wR := mK * wR;
       //    
       wMax := wB;
       if wG > wMax then wMax := wG;
       if wR > wMax then wMax := wR;
       //   
       if wMax > 255
       then mN := (255 / wMax)
       else if Trunc(wMax) < 1 then mN := 0 else mN := 1;
       //     
       wB := mN * wB;
       wG := mN * wG;
       wR := mN * wR;
       // ---------------------
       //     (  )
       // if Trunc(wB) > 255 then ShowMessage( 'wB = ' + FloatToStr(wB));
       // if Trunc(wG) > 255 then ShowMessage( 'wG = ' + FloatToStr(wG));
       // if Trunc(wR) > 255 then ShowMessage( 'wR = ' + FloatToStr(wR));
       // ---------------------
       //      
       RqBGR.B := Trunc(wB);
       RqBGR.G := Trunc(wG);
       RqBGR.R := Trunc(wR);
    end;
    //    
  end;
end;
// ------------------------------------------------------------------------
//    RqImg.Picture.BitMap
// ( ,    )
//  :
//      ApllyFuncForImg(pImgeMain);
//      pImgeMain.Repaint;
// ------------------------------------------------------------------------
// 24.02.2013
procedure ApllyFuncForImg(RqImg : TImage);
type TpBArr = ^TBArr;
     TBArr = array[0..32767] of Byte;
var  BMCol, BMRow : integer;
     WRow, WCol   : integer;
     pRow  : TpBArr;
     wBGR  : TBGR;
begin
  // ------------------------------
  //    - .
  PrepareFuncTab();
  if Length(FuncTab) < 2 then Exit;
  // ------------------------------
  with RqImg.Picture
  do begin
     if (BitMap.Height > 0) and (BitMap.Width > 0)
        and (BitMap.PixelFormat= pf24bit)
     then begin
       BMRow := BitMap.Height;
       BMCol := 3 * BitMap.Width;
       for WRow := 0 to (BMRow - 1)
       do begin
          pRow := BitMap.ScanLine[WRow];
          WCol := 0;
          while WCol < BMCol
          do begin
             wBGR.B := pRow^[WCol];     // B
             wBGR.G := pRow^[WCol+1];   // G
             wBGR.R := pRow^[WCol+2];   // R
             // ----------------
             //  
             RunFuncTabOnePoint(wBGR);
             // ----------------
             pRow^[WCol]   := wBGR.B;   // B
             pRow^[WCol+1] := wBGR.G;   // G
             pRow^[WCol+2] := wBGR.R;   // R
             // ----------------
             WCol := WCol + 3;
          end;
       end;
     end;
  end;
end;

// ------------------------------------------------------------------------
//     BGR- 
// ------------------------------------------------------------------------
// 24.02.2013
//    TImgTabBGR  
//      TImgTabBGR
procedure ApllyFuncForTabBGR (ptSourceArray : ptImgTabBGR;
                              ptTargetArray : ptImgTabBGR;
                              Progress      : TProgressBar);
//
var SRow, PMCol, WCol : integer;
    wBGR  : TBGR;
begin
   //  
   if Assigned(ptSourceArray) and Assigned(ptTargetArray)
   then begin
      //  
      if  Length(ptSourceArray^) > 0
      then begin
         Progress.Min := 0;
         Progress.Max := Length(ptSourceArray^);
         Progress.Position := Progress.Min;
         // ------------------------------
         //    - .
         PrepareFuncTab();
         if Length(FuncTab) < 2 then Exit;
         try
           //    
           SetLength(ptTargetArray^, Length(ptSourceArray^));
           for SRow := 0 to High(ptSourceArray^) do
           begin
             //       
             SetLength(ptTargetArray^[SRow], Length(ptSourceArray^[SRow]));
             PMCol := Length(ptSourceArray^[SRow]);
             WCol := 0;
             while WCol < PMCol
             do begin
                wBGR.B := ptSourceArray^[SRow, WCol];     // B
                wBGR.G := ptSourceArray^[SRow, WCol+1];   // G
                wBGR.R := ptSourceArray^[SRow, WCol+2];   // R
                // ----------------
                //  
                RunFuncTabOnePoint(wBGR);
                // ----------------
                ptTargetArray^[SRow, WCol]   := wBGR.B;   // B
                ptTargetArray^[SRow, WCol+1] := wBGR.G;   // G
                ptTargetArray^[SRow, WCol+2] := wBGR.R;   // R
                // ----------------
                WCol := WCol + 3;
             end;
             Progress.Position := Progress.Position + 1;
           end;
         except
            SetLength(ptTargetArray^, 0);
            MessageDlg('TabBRGtoTabBGR :    .',
                        mtWarning, [mbOk], 0);
         end;
         Progress.Position := 0;
      end;
   end;
end;
// ------------------------------------------------------------------------
// 05.03.2013
//      
procedure TFormGistogram.TB1RunClick(Sender: TObject);
begin
  ApllyFuncForTabBGR (Addr(SrcImgTabBGR),
                       Addr(TrgImgTabBGR),
                       ProgressBar1);
   //     Image
   ImgTabToImage(Addr(TrgImgTabBGR), pImageTarget, ProgressBar1);
   //   
   SpButGistTrg.Down := True;
   SpButGistTrgClick(nil);
   //     
   flgFuncApply  := True;
   //   
   Self.Close;
end;

// ------------------------------------------------------------------------
//          
// ------------------------------------------------------------------------
// 05.03.2013
procedure TFormGistogram.TB1SaveToFileClick(Sender: TObject);
var wPntArr : TPointArray;   //   
begin
    wPntArr  := PointEditor.SavePointArray;
    //     
    SaveFuncToFile(SaveDialog1, wPntArr);
end;
// ------------------------------------------------------------------------
// 05.03.2013
procedure TFormGistogram.TB1LoadFromFileClick(Sender: TObject);
var wPntArr : TPointArray;   //   
begin
   //     
   wPntArr := LoadFuncFromFile(OpenDialog1);
   if Length(wPntArr) > 0
   then begin
     // ---------------------------------------------------
     //   (  )   
     // ----------------------------------------------------
     //     
     PointEditor.LoadPointArray(wPntArr);
     //   
     MemoRep.Clear;
     ShowPointArray(wPntArr, MemoRep);
   end;
end;

// ------------------------------------------------------------------------
//         
// ------------------------------------------------------------------------
// 17.02.2013
//    
function GetFunctionVal (RqFuncCode : byte; X : Extended) : Extended;
begin
   case RqFuncCode of
   0 : Result := X;
   1 : Result := Ln(1 + X);
   2 : Result := Exp(X)-1;
   3 : Result := Sqrt(X);
   4 : Result := X * X;
   5 : Result := Sin(X * Pi / 4);
   else Result := X;             // 
   end;
end;
// ------------------------------------------------------------------------
// 05.03.2013
procedure TFormGistogram.cbBoxFuncFormulaClick(Sender: TObject);
begin
  //       
  FuncToPointEditor(cbBoxFuncFormula.ItemIndex);
end;
// ------------------------------------------------------------------------
// 05.03.2013
//    
procedure TFormGistogram.UpDownXClick(Sender: TObject; Button: TUDBtnType);
begin
   with UpDownX do
   begin
      if Position >= Max then Position := Max;
      if Position <= Min then Position := Min;
      FuncXE  := FuncXMin
              + (FuncXMax - FuncXMin)* Position / Max;
      EdXE.Text  := FloatToStr(FuncXE);
   end;
   //      
   FuncToPointEditor(cbBoxFuncFormula.ItemIndex);
end;
// ------------------------------------------------------------------------
// 05.03.2013
procedure TFormGistogram.cbBoxMaxXNumbClick(Sender: TObject);
begin
    //     
    case cbBoxMaxXNumb.ItemIndex of
    0 : MaxFuncNumb := 4;
    1 : MaxFuncNumb := 8;
    2 : MaxFuncNumb := 16;
    3 : MaxFuncNumb := 32;
    else MaxFuncNumb := 16;
    end;
    //       
    FuncToPointEditor(cbBoxFuncFormula.ItemIndex);
end;
// ---------------------------------------------------------------------------
// 17.02.2013
//       
//        !
// (      Min  Max)
procedure TFormGistogram.FuncToPointEditor(RqFuncCode : byte);
//
var   Ind      : integer;
      wX       : Extended;
      wY       : Extended;
      FuncMax  : Extended;
      FuncMin  : Extended;
      FuncNrm  : Extended;
      XL       : integer;
      YL       : integer;
begin
   //  
   if MaxFuncNumb < 2 then Exit;
   SetLength(PointArray, MaxFuncNumb);
   //      
   FuncMin := GetFunctionVal(RqFuncCode, FuncXMin);
   FuncMax := FuncMin;
   for Ind := 0 to High(PointArray)
   do begin
      wX := (FuncXE - FuncXMin) * Ind / (MaxFuncNumb -1);
      wY := GetFunctionVal(RqFuncCode, wX);
      if wY < FuncMin then FuncMin := wY;
      if wY > FuncMax then FuncMax := wY;
   end;
   //   
   if (FuncMin < 0) or (FuncMax < 0) or (FuncMin = FuncMax)
   then begin
     SetLength(PointArray, 0);
     ShowMessage ('   ');
     Exit;
   end;
   //     
   for Ind := 0 to High(PointArray)
   do begin
      wX := (FuncXE - FuncXMin) * Ind / (MaxFuncNumb -1);
      wY := GetFunctionVal(RqFuncCode, wX);
      //      (0..1)
      FuncNrm := wY/(FuncMax - FuncMin);
      //      (0..255)
      XL  := Round(Ind * 255 / (MaxFuncNumb -1));
      //      (0..255)
      YL  := Round( 255 * FuncNrm);
      //   
      PointArray[Ind].X := XL;
      PointArray[Ind].Y := YL;
   end;
   if Assigned(PointEditor)
   then begin
      //     
      PointEditor.LoadPointArray(PointArray);
      //   
      MemoRep.Clear;
      ShowPointArray(PointArray, MemoRep);
   end;
end;

// ------------------------------------------------------------------------
//         
// ------------------------------------------------------------------------
// 06.03.2013
//    
procedure TFormGistogram.cbBoxFuncTypeClick(Sender: TObject);
begin
  //        
  SpecFuncToPointEditor();
end;
// ------------------------------------------------------------------------
// 06.03.2013
//      
procedure TFormGistogram.UpDnLGrateClick(Sender: TObject;
  Button: TUDBtnType);
begin
  with UpDnLGrate do
  begin
      if Position >= Max then Position := Max;
      if Position <= Min then Position := Min;
      EdLGrate.Text := IntToStr(Position);
  end;
  //        
  SpecFuncToPointEditor();
end;
// ------------------------------------------------------------------------
// 06.03.2013
//     
procedure TFormGistogram.cbBoxSectionNumbClick(Sender: TObject);
begin
  //        
  SpecFuncToPointEditor();
end;
// ------------------------------------------------------------------------
// 06.03.2013
//        
procedure TFormGistogram.SpecFuncToPointEditor();
const GateYL = 6;
var NumSect  : integer;
    LenSect  : integer;
    LenGate  : integer;
    NumPoint : integer;
    wXB, wXE : integer;
    wYB, wYE : integer;
    wInd     : integer;
var wPArr  : TPointArray;   //   
begin
    //  
    if (cbBoxFuncType.ItemIndex < 1) or (cbBoxFuncType.ItemIndex > 2)
    then Exit;
    //   
    case cbBoxSectionNumb.ItemIndex of
    0 : NumSect := 4;
    1 : NumSect := 8;
    2 : NumSect := 16;
    3 : NumSect := 32;
    else NumSect := 4
    end;
    //   
    LenSect := 256 div NumSect;
    //   
    LenGate := UpDnLGrate.Position;
    //   
    if LenGate > 0
    then NumPoint := NumSect * 4
    else NumPoint := NumSect * 2;
    //   
    SetLength(wPArr, NumPoint + 1);
    //   
    case cbBoxFuncType.ItemIndex of
    // -----------------------------------------
    1 : begin
           if LenGate < 1  //   
           then begin
              //     
              wInd := 0;
              repeat
                 //    
                 wXB := (wInd div 2) * LenSect;
                 wXE := wXB;
                 //    
                 wYB := wXB;
                 wYE := LenSect * ((wInd div 2) + 1);
                 //    
                 if wYE > 255 then wYE := 255;
                 //   
                 wPArr[wInd].X := wXB;
                 wPArr[wInd].Y := wYB;
                 wPArr[wInd+1].X := wXE;
                 wPArr[wInd+1].Y := wYE;
                 //    
                 wInd := wInd + 2;
              until wInd > High(wPArr) - 1;
              //  
              wPArr[High(wPArr)].X := 255;
              wPArr[High(wPArr)].Y := 255;
           end
           else begin //   
               //     
              wInd := 0;
              repeat
                 //    
                 wXB := (wInd div 4) * LenSect;
                 wXE := wXB + LenGate;
                 //    
                 wYB := wXB;
                 wYE := LenSect * ((wInd div 4) + 1);
                 //    
                 if wYE > 255 then wYE := 255;
                 //   
                 wPArr[wInd].X := wXB;
                 wPArr[wInd].Y := wYB;
                 wPArr[wInd+1].X := wXB;
                 wPArr[wInd+1].Y := GateYL;
                 wPArr[wInd+2].X := wXE;
                 wPArr[wInd+2].Y := GateYL;
                 wPArr[wInd+3].X := wXE;
                 wPArr[wInd+3].Y := wYE;
                 //    
                 wInd := wInd + 4;
              until wInd > High(wPArr) - 1;
              //  
              wPArr[High(wPArr)].X := 255;
              wPArr[High(wPArr)].Y := 255;
           end;
        end;
    // -----------------------------------------
    2 : begin
           if LenGate < 1  //   
           then begin
              //     
              wInd := 0;
              repeat
                 //    
                 wXB := (wInd div 2) * LenSect;
                 wYB := wXB;
                 //    
                 wXE := wXB + (LenSect div 2);
                 wYE := wXE;
                 //    
                 if wYE > 255 then wYE := 255;
                 //   
                 wPArr[wInd].X   := wXB;
                 wPArr[wInd].Y   := wYB;
                 wPArr[wInd+1].X := wXE;
                 wPArr[wInd+1].Y := wYE;
                 //    
                 wInd := wInd + 2;
              until wInd > High(wPArr) - 1;
              //  
              wPArr[High(wPArr)].X := 255;
              wPArr[High(wPArr)].Y := 255;
           end
           else begin //   
               //     
              wInd := 0;
              repeat
                 //    
                 wXB := (wInd div 4) * LenSect;
                 wYB := wXB;
                 //    
                 wXE := wXB + LenGate;
                 wYE := wXE;
                 //    
                 if wYE > 255 then wYE := 255;
                 //   
                 wPArr[wInd].X := wXB;
                 wPArr[wInd].Y := wYB;
                 wPArr[wInd+1].X := wXB;
                 wPArr[wInd+1].Y := GateYL;
                 wPArr[wInd+2].X := wXE;
                 wPArr[wInd+2].Y := GateYL;
                 wPArr[wInd+3].X := wXE;
                 wPArr[wInd+3].Y := wYE;
                 //    
                 wInd := wInd + 4;
              until wInd > High(wPArr) - 1;
              //  
              wPArr[High(wPArr)].X := 255;
              wPArr[High(wPArr)].Y := 255;
           end;
        end;
    // -----------------------------------------
    end;
    if Assigned(PointEditor)
    then begin
      //     
      PointEditor.LoadPointArray(wPArr);
      //   
      MemoRep.Clear;
      ShowPointArray(wPArr, MemoRep);
    end;
    SetLength(wPArr, 0);
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================



end.
